#include <algorithm>
#include <iostream>
#include <set>
#include <vector>

using ll = long long;

ll ceil(ll a, ll b) {
    if (a % b == 0) {
        return a / b;
    } else {
        return (a / b) + 1;
    }
}

std::set<ll> dels(ll a) {
    std::set<ll> ans;
    ll n = 1;
    while (n * n < a) {
        if (a % n == 0) {
            ans.insert(n);
            ans.insert(a / n);
        }
        n++;
    }
    if (n * n == a) {
        ans.insert(n);
    }
    return ans;
}

int main() {
    int t;
    std::cin >> t;
    for (int step = 0; step < t; ++step) {
        ll x, y;
        std::cin >> x >> y;
        ll t = y;
        if (y == x) {
            t = 0;
        } else {
            ll n = ceil(y, x);
            auto res = dels(y - x);
            auto nm1ptr = res.lower_bound(n - 1);
            if (nm1ptr != res.end()) {
                n = *nm1ptr + 1;
            } else {
                n = y - x + 1;
            }
            t = (x * n - y) / (n - 1);
        }
        std::cout << t << "\n";
    }
}